/*
 * Vuln Title: XXXX
 *
 * Copyright (C) 2005-2010 Sourcefire, Inc. All Rights Reserved
 *
 * Written by XXXX, Sourcefire VRT <XXXX@sourcefire.com>
 *
 * Auto-generated by XXXX
 *
 * This file may contain proprietary rules that were created, tested and
 * certified by Sourcefire, Inc. (the "VRT Certified Rules") as well as
 * rules that were created by Sourcefire and other third parties and
 * distributed under the GNU General Public License (the "GPL Rules").  The
 * VRT Certified Rules contained in this file are the property of
 * Sourcefire, Inc. Copyright 2005 Sourcefire, Inc. All Rights Reserved.
 * The GPL Rules created by Sourcefire, Inc. are the property of
 * Sourcefire, Inc. Copyright 2002-2005 Sourcefire, Inc. All Rights
 * Reserved.  All other GPL Rules are owned and copyrighted by their
 * respective owners (please see www.snort.org/contributors for a list of
 * owners and their respective copyrights).  In order to determine what
 * rules are VRT Certified Rules or GPL Rules, please refer to the VRT
 * Certified Rules License Agreement.
 */

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

//#define DEBUG
#ifdef DEBUG
#define DEBUG_SO(code) code
#else
#define DEBUG_SO(code)
#endif


#ifndef READ_BIG_32
#define READ_BIG_32(p) (*(p) << 24)              \
                | (*((u_int8_t *)(p) + 1) << 16) \
                | (*((u_int8_t *)(p) + 2) << 8)  \
                | (*((u_int8_t *)(p) + 3))
#endif

#ifndef READ_BIG_16
#define READ_BIG_16(p) (*(p) << 8)        \
                | (*((u_int8_t *)(p) + 1))
#endif

//typedef struct _PositionInfo {
//   u_int32_t fileOffset;
//   u_int32_t eblcOffset;
//   u_int32_t ebdtOffset;
//   u_int32_t eblcSize;
//   u_int32_t ebdtSize;
//   u_int32_t imageDataOffset;
//   u_int32_t ttfHeaderSize;
//   u_int8_t  usSubPpemX;
//   u_int8_t  usSubPpemY;
//   u_int8_t  eblcParsed;
//   u_int8_t  eblcDataParsed;
//   u_int8_t  ebdtParsed;
//   u_int8_t  headersParsed;
//   u_int8_t  ignore;
//} PositionInfo;

//static int parseEBLCDirectoryEntry(const u_int8_t *cursor_normal, const u_int8_t *end_of_payload, PositionInfo *pi);
//static int parseAndDetect(const u_int8_t *cursor_normal, const u_int8_t *end_of_payload, PositionInfo *pi);

/* declare detection functions */
int rule20539eval(void *p);

/* declare rule data structures */
/* flow:established, to_client; */
static FlowFlags rule20539flow0 = 
{
    FLOW_ESTABLISHED|FLOW_ONLY_REASSMBLED|FLOW_TO_CLIENT
};

static RuleOption rule20539option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule20539flow0
    }
};

//#ifdef MISSINGFILEDATA
static ContentInfo rule20539content1 =
{
    (u_int8_t *) "DFASDFLAKFJ8923A89SFHASDIOFHASDUIVH9234RQASEFUIF78A234RQEF76876sdfsdf", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_FAST_PATTERN|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};
static RuleOption rule20539option1 =
{
    OPTION_TYPE_CONTENT,
    {
        &rule20539content1
    }
};

//#else
#if 0

// content:"|00|", depth 0, fast_pattern; 
static ContentInfo rule20539content1 = 
{
    (u_int8_t *) "|00|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_FAST_PATTERN|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule20539option1 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule20539content1
    }
};
// content:"EBLC", depth 0; 
static ContentInfo rule20539content2 = 
{
    (u_int8_t *) "EBLC", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule20539option2 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule20539content2
    }
};

// content:"EBDT", depth 0; 
static ContentInfo rule20539content3 = 
{
    (u_int8_t *) "EBDT", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule20539option3 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule20539content3
    }
};

// content:"|0D 0A 0D 0A|", depth 0; 
static ContentInfo rule20539content4 = 
{
    (u_int8_t *) "|0D 0A 0D 0A|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule20539option4 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule20539content4
    }
};

/* flowbits:isset "file.ttf"; */
static FlowBitsInfo rule20539flowbits5 =
{
    "file.ttf",
    FLOWBIT_ISSET,
    0,
};

static RuleOption rule20539option5 =
{
    OPTION_TYPE_FLOWBIT,
    {
        &rule20539flowbits5
    }
};

/* flowbits:isset "file.doc"; */
static FlowBitsInfo rule20539flowbits6 =
{
    "file.doc",
    FLOWBIT_ISSET,
    0,
};

static RuleOption rule20539option6 =
{
    OPTION_TYPE_FLOWBIT,
    {
        &rule20539flowbits6
    }
};

static CursorInfo rule20539cursor7 = 
{
   0,
   CONTENT_BUF_NORMALIZED
};

static RuleOption rule20539option7 = 
{
   OPTION_TYPE_FILE_DATA,
   {
      &rule20539cursor7
   }
};
#endif

/* reference: cve "2011-3402"; */
static RuleReference rule20539ref1 =
{
    "cve", /* type */
    "2011-3402" /* value */
};
static RuleReference rule20539ref2 =
{
     "url", /* type */
     "support.microsoft.com/kb/2639658" /* value */
};

/* references for sid 20539 */
static RuleReference *rule20539refs[] =
{
   &rule20539ref1,
   &rule20539ref2,
    NULL
};



/* metadata for sid 20539 */
/* metadata:; */


static RuleMetaData *rule20539metadata[] =
{
    NULL
};

RuleOption *rule20539options[] =
{
    &rule20539option0,
    &rule20539option1,
//#ifndef MISSINGFILEDATA
#if 0
    &rule20539option2,
    &rule20539option3,
    &rule20539option4,
    &rule20539option5,
    &rule20539option6,
    &rule20539option7,
#endif
    NULL
};

Rule rule20539 = {
   /* rule header, akin to => tcp any any -> any any */
   {
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "$HTTP_PORTS", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "any", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid */
       20539, /* sigid */
       4, /* revision */
       "attempted-admin", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
//#ifdef MISSINGFILEDATA
       "DELETED WEB-CLIENT Microsoft TrueType font parsing engine sfac_GetSbitBitmap elevation of privileges attempt",     /* message */
//#else
//       "WEB-CLIENT Microsoft TrueType font parsing engine sfac_GetSbitBitmap elevation of privileges attempt",     /* message */
//#endif
       rule20539refs /* ptr to references */
       ,rule20539metadata
   },
   rule20539options, /* ptr to rule options */
   &rule20539eval, /* use the built in detection function */
//#ifdef MISSINGFILEDATA
   1 /* Trick into thinking we are initialized */
//#else
//   0 /* am I initialized yet? */
//#endif
};

/* detection functions */
// #if 0 // Don't compile the detection functions if they're not used
int rule20539eval(void *p) {
    const u_int8_t *cursor_normal = 0, *cursor_detect = 0, *beg_of_payload = 0, *end_of_payload = 0, *end_of_data = 0;
    const u_int8_t *eblcPacketOffset = 0, *ebdtPacketOffset = 0;
    u_int32_t tmp_value = 0, payload_size = 0;

    SFSnortPacket *sp = (SFSnortPacket *) p;
//    PositionInfo *pi = NULL;

    // This rule is in no policies, but in case anyone enables it manually...
    // If anyone notices this comment, there's a major rewrite coming out RSN
    // so disabling this a completely temporary thing.
    return RULE_NOMATCH;

#if 0
#ifdef MISSINGFILEDATA
return RULE_NOMATCH;
#else

    if(sp == NULL)
        return RULE_NOMATCH;

    if(sp->payload == NULL)
        return RULE_NOMATCH;
    
    // flow:established, to_client;
    if (checkFlow(p, rule20539options[0]->option_u.flowFlags) <= 0 ) {
      return RULE_NOMATCH;
   }
   
   // Only pay attention to file.doc or file.ttf ( only checking for file.ttf currently)
   if ((processFlowbits(p, rule20539options[5]->option_u.flowBit) <= 0)) {
      return RULE_NOMATCH;
   }
   
   // Fetch or allocate/store storage for our rule data
   pi = (PositionInfo *) getRuleData(sp, (u_int32_t)rule20539.info.sigID);
   if (pi == NULL) {
      if((pi = (PositionInfo *) allocRuleData(sizeof(PositionInfo))) == NULL) {
         return RULE_NOMATCH; 
      }
      
      if (storeRuleData(sp, pi, rule20539.info.sigID, &freeRuleData) < 0) {
         freeRuleData(pi);
         return RULE_NOMATCH;
      }
   }
   // Should we be ignoring the rest of this stream?
   if(pi->ignore == 1) {
      return RULE_NOMATCH;
   }

   // Move to FILE_DATA
   if(fileData(p, rule20539options[7]->option_u.cursor, &cursor_normal) <= 0) {
      DEBUG_SO(fprintf(stderr, "Move to FILE_DATA failed\n"));
      pi->ignore = 1;
      return RULE_NOMATCH;
   }

   // Move this to a single call to avoid multiple redundant calls later
   if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_payload, &end_of_payload) <= 0) {
      return RULE_NOMATCH;
   }

   // If we have read past the table entries in the header, and haven't seen EBLC or EBDT, ignore the rest of the file
   if((pi->headersParsed == 0) && (pi->fileOffset > pi->ttfHeaderSize)) {
      DEBUG_SO(fprintf(stderr, "Header read without seeing EBLC or EBDT tables.  Ignoring the rest of the stream.\n"));
   
      // Ignore the rest of the stream
      pi->ignore = 1;
      return RULE_NOMATCH;
   }

   // This will be zero if it was just allocated
   payload_size = (end_of_payload - beg_of_payload);
   pi->fileOffset += payload_size;

   // Beginning of the first packet?
   if (pi->fileOffset == payload_size) {

      // Enough data to read the header?
      if((cursor_normal + 6) > end_of_payload) {
         return RULE_NOMATCH;
      }

      // Start by checking the version
      tmp_value = READ_BIG_32(cursor_normal);

      // Make sure this file is a valid TTF
      if((tmp_value != 0x00010000) && (tmp_value != 0x00020000)) {
         DEBUG_SO(fprintf(stderr, "Invalid font version: %d\n", tmp_value));
         pi->ignore = 1;
         return RULE_NOMATCH;
      }

      // Read the number of tables in this file
      tmp_value = READ_BIG_16(cursor_normal + 4);
      
      // Make sure this is sane
      if(tmp_value > 30) {
         DEBUG_SO(fprintf(stderr, "Too many TTF table entries: %d\n", tmp_value));
         pi->ignore = 1;
         return RULE_NOMATCH;
      }

      // Finally store the total header size of this file for later (tables are 16 bytes in size)
      pi->ttfHeaderSize = (tmp_value * 16) + 12;
         
   }

   if (pi->eblcParsed && !pi->eblcDataParsed) {

      if (pi->fileOffset > pi->eblcOffset) {
         eblcPacketOffset = beg_of_payload + (pi->eblcOffset - (pi->fileOffset - payload_size));

            // Make sure this is sane
            if((eblcPacketOffset < beg_of_payload) || (eblcPacketOffset >= end_of_payload)) {
                pi->ignore = 1;
                return RULE_NOMATCH;
            }
         end_of_data = eblcPacketOffset + pi->eblcSize;

         // Make sure all of our data is in the packet
         if((end_of_data < beg_of_payload) || (end_of_data >= end_of_payload)) {
            DEBUG_SO(fprintf(stderr, "End of EBLCDirectoryEntry beyond end of payload\n"));
            pi->ignore = 1;
            return RULE_NOMATCH;
         }

         if(parseEBLCDirectoryEntry(eblcPacketOffset, end_of_data, pi) == RULE_NOMATCH) {

            // If this fails, we should probably just stop processing this file
            pi->ignore = 1;
            return RULE_NOMATCH;
         }
         
         pi->eblcDataParsed = 1;
      }
   }
   else {
      if (contentMatch(p, rule20539options[2]->option_u.content, &cursor_normal) > 0) {

         if ((cursor_normal + 12) > end_of_payload) {
            return RULE_NOMATCH;
         }

         // Get the offset to the EBLC table
         cursor_detect = (cursor_normal + 4);
         pi->eblcOffset = (READ_BIG_32(cursor_detect));
         pi->eblcSize = READ_BIG_32(cursor_detect + 4);
         pi->eblcParsed = 1;
         
         // Set this to minimize code early on
         if(pi->ebdtParsed == 1) {
            pi->headersParsed = 1;
         }
         DEBUG_SO(fprintf(stderr, "Parsed EBLC - Offset: 0x%08x Size: 0x%08x\n", pi->eblcOffset, pi->eblcSize));
      }
   }

   if (pi->ebdtParsed) {
      if (pi->fileOffset > pi->ebdtOffset) {
         ebdtPacketOffset = beg_of_payload + (pi->ebdtOffset - (pi->fileOffset - payload_size));

         // Make sure this is sane
         if((ebdtPacketOffset < beg_of_payload) || (ebdtPacketOffset >= end_of_payload)) {
            pi->ignore = 1;
            return RULE_NOMATCH;
         }

         // Make sure we've already parsed eblc
         if(pi->eblcDataParsed == 0) {
            DEBUG_SO(fprintf(stderr, "Found EBDT but we have not parsed an EBLC structure\n"));
            pi->ignore = 1;
            return RULE_NOMATCH;
         }
         end_of_data = ebdtPacketOffset + pi->ebdtSize;
         
         // Make sure all of our data is in the packet
         if((end_of_data < beg_of_payload) || (end_of_data >= end_of_payload)) {
            DEBUG_SO(fprintf(stderr, "End of EBDTDirectoryEntry beyond end of payload\n"));
            pi->ignore = 1;
            return RULE_NOMATCH;
         }


         // If we've made it here, we should ignore the rest regardless
         pi->ignore = 1;
         return parseAndDetect(ebdtPacketOffset, end_of_data, pi);
      }
   }
   else {
      if (contentMatch(p, rule20539options[3]->option_u.content, &cursor_normal) > 0) {

         if ((cursor_normal + 12) > end_of_payload) {
            return RULE_NOMATCH;
         }

         // Get the offset to the EBDT table
         cursor_detect = (cursor_normal + 4);
         pi->ebdtOffset = (READ_BIG_32(cursor_detect));
         pi->ebdtSize = READ_BIG_32(cursor_detect + 4);
         pi->ebdtParsed = 1;

         // Set this to minimize code early on
         if(pi->eblcParsed == 1) {
            pi->headersParsed = 1;
         }
   
         DEBUG_SO(fprintf(stderr, "Parsed EBDT - Offset: 0x%08x Size: 0x%08x\n", pi->ebdtOffset, pi->ebdtSize));
      }
   }

   DEBUG_SO(
      fprintf(stderr, "Offset to eblc: 0x%08x\n", pi->eblcOffset);
      fprintf(stderr, "Offset to ebdt: 0x%08x\n", pi->ebdtOffset);
      fprintf(stderr, "Payload size: %d\n", payload_size);
      fprintf(stderr, "Cumulative size: %d\n", pi->fileOffset);
   );
#endif
   return RULE_NOMATCH;
#endif
}

#if 0
// Returns RULE_MATCH or RULE_NOMATCH
static int parseEBLCDirectoryEntry(
      const u_int8_t    *cursor_normal,         // Should point to the beginning of the EBLCDirectoryEntry data
      const u_int8_t    *end_of_payload,        // Should point to the end of the EBLCDirectoryEntry data
      PositionInfo      *pi)                    // Struct to hold all the relevant data we extract
{

   u_int32_t length = 0, bitMapSizeTable_entries = 0, indexSubTableArray_entries = 0, version = 0, offset = 0;
   u_int8_t indexSubTableArray_i = 0, bitMapSizeTable_i = 0;
   const u_int8_t *cursor_table = 0;

   // Make sure we have all the data we need
   if((pi->eblcSize < 8) || (cursor_normal + pi->eblcSize) > end_of_payload) {
      DEBUG_SO(fprintf(stderr, "Not enough data to read entire eblc data block\n"));
      return RULE_NOMATCH;
   }

   // Save this for later
   cursor_table = cursor_normal;
   
   // Extra checks to make sure we are in the right place
   version = READ_BIG_32(cursor_normal);
   bitMapSizeTable_entries = READ_BIG_32(cursor_normal + 4);
   DEBUG_SO(fprintf(stderr, "bitmapSizeTable entries: %d\n", bitMapSizeTable_entries));

   // Correct version?
   if(version != 0x20000) {
      DEBUG_SO(fprintf(stderr, "Incorrect EBLCDirectoryEntry version: 0x%08x\n", version));
      return RULE_NOMATCH;
   }

   // Do we have a sane number of entries?
   if(bitMapSizeTable_entries > 20) {
      DEBUG_SO(fprintf(stderr, "EBLCDirectoryEntry bitMapSizeTables too large: 0x%08x\n", bitMapSizeTable_entries));
      return RULE_NOMATCH;
   }

   // Jump to the start of the tables
   cursor_normal += 8;

   // Loop through the bitMapSizeTables looking for a bitDepth of 1
   for(bitMapSizeTable_i = 0; bitMapSizeTable_i < bitMapSizeTable_entries; bitMapSizeTable_i++) {

      // Make sure there is enough data to read this entry
      if((cursor_normal + 48) > end_of_payload) {
         DEBUG_SO(fprintf(stderr, "Not enough data to read %d bitMapSizeTable entry\n", bitMapSizeTable_i));
         return RULE_NOMATCH;
      }

      // bitDepth == 1?
      if(*(cursor_normal + 46) == 1) {

         // Store the ppemX and Y values directly before bitDepth
         pi->usSubPpemX = *(cursor_normal + 44);
         pi->usSubPpemY = *(cursor_normal + 45);
         indexSubTableArray_entries = READ_BIG_32(cursor_normal + 8);

       // These shouldn't be zero
        if((pi->usSubPpemX == 0) || (pi->usSubPpemY == 0)) {
         DEBUG_SO(fprintf(stderr, "pi->usSubPpemX: %d pi->usSubPpemY: %d\n", pi->usSubPpemX, pi->usSubPpemY));
         return RULE_NOMATCH;
       }

         DEBUG_SO(
         fprintf(stderr, "usSubPpemX: %02x\n", pi->usSubPpemX);
            fprintf(stderr, "usSubPpemY: %02x\n", pi->usSubPpemY);
           fprintf(stderr, "indexSubTableArrayList entries: %d\n", indexSubTableArray_entries);
       );

         // Make sure entries is somewhat sane
         if(indexSubTableArray_entries > 20) {
            DEBUG_SO(fprintf(stderr, "indexSubTableArrayList entries too large\n"));
            return RULE_NOMATCH;
         }

         // Now we need to move to beginning of this table + indexSubTableArrayOffset
         offset = READ_BIG_32(cursor_normal);
         length = READ_BIG_32(cursor_normal + 4);
         cursor_table += offset;

         // Store cursor_table at the beginning of the array list as all offsets are from that
         // This check also checks that there is enough data to read the entire subtable
         if((cursor_table + length) > end_of_payload) {
            DEBUG_SO(fprintf(stderr, "Not enough data to read indexSubTableArray\n"));
            return RULE_NOMATCH;
         }
         cursor_normal = cursor_table;

         // Enough data?
         if((cursor_normal + (indexSubTableArray_entries * 8)) > end_of_payload) {
            DEBUG_SO(fprintf(stderr, "Not enough data to read indexSubTable array\n"));
            return RULE_NOMATCH;
         }

         // Check each entry
         for(indexSubTableArray_i = 0; indexSubTableArray_i < indexSubTableArray_entries; indexSubTableArray_i++) {
            
            // Jump to the beginning of the indexSubTable data
            cursor_normal = cursor_table + (indexSubTableArray_i * 8); // Each entry is 8 bytes in size

            offset = READ_BIG_32(cursor_normal + 4);
            cursor_normal = cursor_table + offset;  // This holds the offset from the beginning of the entire array
            
            // Make sure we have enough data to read at the offset
            if((cursor_normal + 10) > end_of_payload) {
               DEBUG_SO(fprintf(stderr, "Not enough data to read indexSubTable entry %i data from offset\n", indexSubTableArray_i));
               return RULE_NOMATCH;
            }

            // imageFormat == 8 or 9?
            if(((READ_BIG_16(cursor_normal + 2)) == 8) || ((READ_BIG_16(cursor_normal + 2)) == 9)) {

               // Finally save the imageDataOffset
               pi->imageDataOffset = READ_BIG_32(cursor_normal + 4);
               DEBUG_SO(fprintf(stderr, "imageDataOffset: %d\n", pi->imageDataOffset));

               return RULE_MATCH;
            }
         }
      } else {
         cursor_normal += 48; // Move to the next entry
      }
   }
   return RULE_MATCH;
}
#endif

/*    Returns RULE_MATCH or RULE_NOMATCH
   usPpemX and usPpemY can be set by the application at run time and are not set inside of the packet
   The guidance states that because of this, a good heuristic would be to check the following calculations
   with an scaling factor (usPpemX and usPpemY) of up to 8.
   The guidance uses a 4 so the resulting data below may be slightly different
*/  
#if 0 
static int parseAndDetect(
      const u_int8_t    *cursor_normal,         // Should point to the beginning of the EBDTDirectoryEntry data
      const u_int8_t    *end_of_payload,        // Should point to the end of the EBDTDirectoryEntry data
      PositionInfo      *pi)                    // Struct to hold all the relevant data we extract
{
    u_int32_t length = 0, entries = 0, version = 0, offset = 0;
    u_int8_t  usHeight = 0, usWidth = 0, usYOffset = 0, usPpemX = 8, usPpemY = 8;
    u_int16_t usScaledWidth = 0, usScaledHeight = 0, usScaledRowBytes = 0, usOriginalRowBytes = 0;
    u_int32_t ulWorkMemSize = 0, ulBitmapOffset = 0;

   // Enough data to work with?
   if((cursor_normal + 12 + pi->imageDataOffset) >  end_of_payload) {
        DEBUG_SO(fprintf(stderr, "Not enough data to read entire EBDTDirectoryEntry\n"));
      return RULE_NOMATCH;
   }

    // Correct version?
    version = READ_BIG_32(cursor_normal);
    if(version != 0x20000) {
        DEBUG_SO(fprintf(stderr, "Incorrect EBDTDirectoryEntry version: 0x%08x\n", version));
        return RULE_NOMATCH;
    }

    // Save the beginning of this Entry
    cursor_normal += pi->imageDataOffset;

    // Start reading our data
    usHeight =  *(cursor_normal);
    usWidth =   *(cursor_normal + 1);
    usYOffset = *(cursor_normal + 11);

    // Time to start calculating
    usScaledWidth = (usWidth * ( usPpemX << 1 ) + pi->usSubPpemX) / (pi->usSubPpemX << 1);
    usScaledHeight = (usHeight * ( usPpemY << 1 ) + pi->usSubPpemY) / (pi->usSubPpemY << 1);
    usScaledRowBytes = ((usScaledWidth + 31) >> 5) << 2;
    usOriginalRowBytes = ((usWidth + 31) >> 5) << 2;
    ulWorkMemSize = usScaledHeight * usScaledRowBytes;
    ulBitmapOffset = usYOffset * usOriginalRowBytes;

    DEBUG_SO(
      fprintf(stderr, "usHeight: 0x%02x\n", usHeight);
       fprintf(stderr, "usWidth: 0x%02x\n", usWidth);
       fprintf(stderr, "usYOffset: 0x%02x\n", usYOffset);
       fprintf(stderr, "usSubPpemX: 0x%02x\n", pi->usSubPpemX);
       fprintf(stderr, "usSubPpemY: 0x%02x\n", pi->usSubPpemY);
       fprintf(stderr, "usScaledWidth: 0x%04x\n", usScaledWidth);
       fprintf(stderr, "usScaledHeight: 0x%04x\n", usScaledHeight);
       fprintf(stderr, "usScaledRowBytes: 0x%04x\n", usScaledRowBytes);
       fprintf(stderr, "usOriginalRowBytes: 0x%04x\n", usOriginalRowBytes);
       fprintf(stderr, "ulWorkMemSize: 0x%08x\n", ulWorkMemSize);
       fprintf(stderr, "ulBitmapOffset: 0x%08x\n", ulBitmapOffset);
   );

    // We've finally made it
    if(ulBitmapOffset > ulWorkMemSize) {
        return RULE_MATCH;
    }
    return RULE_NOMATCH;
}
#endif

// #endif // 0 Don't compile the detection functions if they're not used
/*
Rule *rules[] = {
    &rule20539,
    NULL
};
*/
