/*
 * Vuln Title: XXXX
 *
 * Copyright (C) 2005-2010 Sourcefire, Inc. All Rights Reserved
 *
 * Written by XXXX, Sourcefire VRT <XXXX@sourcefire.com>
 *
 * Auto-generated by XXXX
 *
 * This file may contain proprietary rules that were created, tested and
 * certified by Sourcefire, Inc. (the "VRT Certified Rules") as well as
 * rules that were created by Sourcefire and other third parties and
 * distributed under the GNU General Public License (the "GPL Rules").  The
 * VRT Certified Rules contained in this file are the property of
 * Sourcefire, Inc. Copyright 2005 Sourcefire, Inc. All Rights Reserved.
 * The GPL Rules created by Sourcefire, Inc. are the property of
 * Sourcefire, Inc. Copyright 2002-2005 Sourcefire, Inc. All Rights
 * Reserved.  All other GPL Rules are owned and copyrighted by their
 * respective owners (please see www.snort.org/contributors for a list of
 * owners and their respective copyrights).  In order to determine what
 * rules are VRT Certified Rules or GPL Rules, please refer to the VRT
 * Certified Rules License Agreement.
 */

/* 
    *** stub ***

alert tcp $EXTERNAL_NET $FILE_DATA_PORTS -> $HOME_NET any ( msg:"EXPLOIT Microsoft Windows Explorer briefcase database memory corruption attempt"; flow:to_client,established; flowbits:isset,file.briefcase; file_data; content:"|44 44 53 48|"; offset:0; depth:4; metadata:policy security-ips drop, service http, service pop3, service imap; reference:cve,2012-1528; classtype:attempted-user; sid:24671; )

*/

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"


//#define DEBUG

#ifdef DEBUG
    #define DEBUG_SO(code) code
#else
    #define DEBUG_SO(code)
#endif

#ifndef READ_LITTLE_32
    #define READ_LITTLE_32(p) (*((u_int8_t *)(p) + 3) << 24) \
             | (*((u_int8_t *)(p) + 2) << 16) \
             | (*((u_int8_t *)(p) + 1) << 8)  \
             | (*(p))
#endif

/* declare detection functions */
int rule24671eval(void *p);

/* declare rule data structures */
/* flow:established, to_client; */
static FlowFlags rule24671flow0 = 
{
   FLOW_ESTABLISHED|FLOW_TO_CLIENT
};

static RuleOption rule24671option0 =
{
   OPTION_TYPE_FLOWFLAGS,
   {
      &rule24671flow0
   }
};

// file_data;
static CursorInfo rule24671file_data1 =
{
   0, /* offset */
   CONTENT_BUF_NORMALIZED /* flags */
};

static RuleOption rule24671option1 =
{
#ifndef MISSINGFILEDATA
   OPTION_TYPE_FILE_DATA,
#else
   OPTION_TYPE_SET_CURSOR,
#endif
   {
      &rule24671file_data1
   }
};

#ifndef CONTENT_FAST_PATTERN_ONLY
#define CONTENT_FAST_PATTERN_ONLY CONTENT_FAST_PATTERN
#endif
// content:"DDSH|02 05 01 14 14 00 00 00|", depth 12, fast_patterny; 
static ContentInfo rule24671content2 = 
{
   (u_int8_t *) "DDSH|02 05 01 14 14 00 00 00|", /* pattern (now in snort content format) */
   12, /* depth */
   0, /* offset */
   CONTENT_FAST_PATTERN|CONTENT_BUF_NORMALIZED, /* flags */
   NULL, /* holder for boyer/moore PTR */
   NULL, /* more holder info - byteform */
   0, /* byteform length */
   0 /* increment length*/
};

static RuleOption rule24671option2 = 
{
   OPTION_TYPE_CONTENT,
   {
      &rule24671content2
   }
};


/* references for sid 24671 */
/* reference: cve "2012-1528"; */
static RuleReference rule24671ref1 = 
{
   "cve", /* type */
   "2012-1528" /* value */
};

/* reference: cve "2012-1527"; */
static RuleReference rule24671ref2 = 
{
   "cve", /* type */
   "2012-1527" /* value */
};

/* reference: cve "2012-1527"; */
static RuleReference rule24671ref3 = 
{
   "url", /* type */
   "technet.microsoft.com/en-us/security/bulletin/MS12-072" /* value */
};

static RuleReference *rule24671refs[] =
{
   &rule24671ref1,
   &rule24671ref2,
   &rule24671ref3,
   NULL
};

/* metadata for sid 24671 */
/* metadata:service http, service imap, service pop3, policy security-ips drop; */
static RuleMetaData rule24671service1 = 
{
   "service http"
};

static RuleMetaData rule24671service2 = 
{
   "service imap"
};

static RuleMetaData rule24671service3 = 
{
   "service pop3"
};

static RuleMetaData rule24671policy1 = 
{
   "policy security-ips drop"
};

static RuleMetaData *rule24671metadata[] =
{
   &rule24671service1,
   &rule24671service2,
   &rule24671service3,
   &rule24671policy1,
   NULL
};

RuleOption *rule24671options[] =
{
   &rule24671option0,
   &rule24671option1,
   &rule24671option2,
   NULL
};

Rule rule24671 = {
   /* rule header, akin to => tcp any any -> any any */
   {
      IPPROTO_TCP, /* proto */
      "$EXTERNAL_NET", /* SRCIP    */
      "$FILE_DATA_PORTS", /* SRCPORT   */
      0, /* DIRECTION */
      "$HOME_NET", /* DSTIP    */
      "any", /* DSTPORT   */
   },
   /* metadata */
   { 
      3,  /* genid */
      24671, /* sigid */
      1, /* revision */
      "attempted-user", /* classification */
      0,  /* hardcoded priority */
      "EXPLOIT Microsoft Windows Explorer briefcase database memory corruption attempt",    /* message */
      rule24671refs, /* ptr to references */
      rule24671metadata /* ptr to metadata */
   },
   rule24671options, /* ptr to rule options */
   &rule24671eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};

/* 
 * "Briefcase Directory" file structure
 *
   Byte Header[14]

   struct VolumeHeader
   {
      UINT32 lcVolumes;
      UINT32 MaxVolumeLength;
   }
    
   // repeated: VolumeHeader.lcVolumes times
   struct VolumeDef
   {
      UINT32 hVol;
      UINT32 LinkInfoLen;
      BYTE bytes[VolumeDef.LinkInfoLen-4];
   } 
    
   struct StringHeaderTable
   {
      UINT32 MaxStringLen;
      UINT32 lcStrings; // count of strings
   }
    
   // repeated: StringHeaderTable.lcStrings times
   struct StringDef
   {
      UINT32 StringId;
      ASCII_SZ String[];
   }
*/


/* detection functions */
int rule24671eval(void *p) {
   const u_int8_t *cursor_normal = 0;
   const u_int8_t *beg_of_payload, *end_of_payload;
   const u_int8_t *tmp_ptr = 0;

   u_int32_t lc_volumes;
   //u_int32_t max_vol_len;
   u_int32_t lc_strings;
   u_int32_t link_info_len;

   int lc_volumes_max = 0; // flag for dos avoidance

   // Iterator
   u_int8_t i = 0;

   SFSnortPacket *sp = (SFSnortPacket *) p;

   if(sp == NULL)
      return RULE_NOMATCH;

   if(sp->payload == NULL)
      return RULE_NOMATCH;
   
   // flow:established, to_client;
   if(checkFlow(p, rule24671options[0]->option_u.flowFlags) <= 0)
      return RULE_NOMATCH;
  
    
   // file_data;
   #ifndef MISSINGFILEDATA
   if(fileData(p, rule24671options[1]->option_u.cursor, &cursor_normal) <= 0)
      return RULE_NOMATCH;
   #else
   if(setCursor(p, rule24671options[1]->option_u.cursor, &cursor_normal) <= 0)
      return RULE_NOMATCH;
   #endif
   
    
   if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_payload, &end_of_payload) != CURSOR_IN_BOUNDS)
      return RULE_NOMATCH;

    // content:"DDSH|02 05 01 14 14 00 00 00|", depth 12, fast_patterny; 
   if(contentMatch(p, rule24671options[2]->option_u.content, &cursor_normal) <= 0)
      return RULE_NOMATCH;
    

   // At offset 0x0C.  We'll jump 20 more bytes before the loop, so do bounds checks here.
   if( cursor_normal + 20 > end_of_payload )
      return RULE_NOMATCH;

   // VolumeHeader.lcVolumes: number of VolumeDef blocks
   lc_volumes = READ_LITTLE_32( cursor_normal + 8 );

   // VolumeHeader.MaxVolumeLength: keep this to validate boundaries
   //max_vol_len = READ_LITTLE_32( cursor_normal + 12 );
   
   DEBUG_SO( fprintf( stderr, "\nReading %d VolumeDef blocks\n", lc_volumes ) );  

   // Put the cursor at the beginning of the first VolumeDef block (static offset @ 0x1c)
   // Jump over VolumeDef[1].hVol while we're at it

   cursor_normal += 20;

   // Limit the number of times we go through the loop.
   if(lc_volumes > 100) {
      lc_volumes = 100;
      lc_volumes_max = 1;
      DEBUG_SO( fprintf( stderr, "\nRestricted number of lc_volumes\n"));
   }

   // Loop through the VolumeDef blocks
   for( i = 0; i < lc_volumes; i++ )
   {
      if( cursor_normal + 4 > end_of_payload )
         return RULE_NOMATCH;
 
      link_info_len = READ_LITTLE_32( cursor_normal );

      // CVE-2012-1527
      // Integer underrun; condition: VolumeDef.LinkInfoLen < 4
      DEBUG_SO( fprintf( stderr, "CVE-2012-1527: Condition - VolumeDef[%d].LinkInfoLen (%d) < 4 ... ", i, link_info_len ) );

      if( link_info_len < 4 )
      {
         DEBUG_SO( fprintf( stderr, "TRUE\n" ) );
         return RULE_MATCH;
      }

      DEBUG_SO( fprintf( stderr, "FALSE\n" ) );
   
      // Continue to find CVE-2012-1528

      tmp_ptr = cursor_normal + link_info_len + 4;

      // Integer overflow check
      if( tmp_ptr < cursor_normal )
         return RULE_NOMATCH;

      // in bounds?
      if( tmp_ptr > end_of_payload )
         return RULE_NOMATCH; 

      // Jump over last VolumeDef.LinkInfoLen and VolumeDef.bytes
      cursor_normal = tmp_ptr; 

   }

   if( cursor_normal + 4 > end_of_payload )
      return RULE_NOMATCH;

   if(lc_volumes_max != 0) {
      DEBUG_SO( fprintf( stderr, "CVE-2012-1528 detection disabled due to too many lc_volumes\n");)
      return RULE_NOMATCH;
   }

   // Should now be at StringHeaderTable.lcStrings
   // In the above for() we see "cursor_normal += ( link_info_len + 4 );", which jumps over VolumeDef.bytes,
   //     and VolumeDef.LinkInfoLen on the next block.  Because StringHeaderTable comes directly after
   //     it will skip over the 4 byte StringHeaderTable.MaxStringLen and drop us at StringHeaderTable.lcStrings

   // Malicious condition: lcStrings * 8 > 0xffffffff
   //  => 0xffffffff / 8 = 0x1fffffff
   //  => lcStrings > 0x1fffffff

   lc_strings = READ_LITTLE_32( cursor_normal );
   
   DEBUG_SO( fprintf( stderr, "CVE-2012-1528: Condition - StringHeaderTable.lcStrings (0x%x) > 0x1fffffff ... ", lc_strings ) );

   if( lc_strings > 0x1FFFFFFF )
   {
      DEBUG_SO( fprintf( stderr, "TRUE\n" ) );
      return RULE_MATCH;
   }

   DEBUG_SO( fprintf( stderr, "FALSE\n" ) );

   return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule24671,
    NULL
};
*/







