/*
 * Vuln Title: XXXX
 *
 * Copyright (C) 2005-2010 Sourcefire, Inc. All Rights Reserved
 *
 * Written by XXXX, Sourcefire VRT <XXXX@sourcefire.com>
 *
 * Auto-generated by XXXX
 *
 * This file may contain proprietary rules that were created, tested and
 * certified by Sourcefire, Inc. (the "VRT Certified Rules") as well as
 * rules that were created by Sourcefire and other third parties and
 * distributed under the GNU General Public License (the "GPL Rules").  The
 * VRT Certified Rules contained in this file are the property of
 * Sourcefire, Inc. Copyright 2005 Sourcefire, Inc. All Rights Reserved.
 * The GPL Rules created by Sourcefire, Inc. are the property of
 * Sourcefire, Inc. Copyright 2002-2005 Sourcefire, Inc. All Rights
 * Reserved.  All other GPL Rules are owned and copyrighted by their
 * respective owners (please see www.snort.org/contributors for a list of
 * owners and their respective copyrights).  In order to determine what
 * rules are VRT Certified Rules or GPL Rules, please refer to the VRT
 * Certified Rules License Agreement.
 */

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"
#include "so-util_base64-decode.h"

#define MAX_BASE64_BUFFER_SIZE 256

//#define DEBUG
#ifdef DEBUG
#define DEBUG_SO(code) code
#else
#define DEBUG_SO(code)
#endif

/* declare detection functions */
int rule17697eval(void *p);

/* declare rule data structures */
/* flow:established, to_server; */
static FlowFlags rule17697flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule17697option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule17697flow0
    }
};
// content:"-----BEGIN PGP MESSAGE-----", depth 0, nocase, fast_pattern; 
static ContentInfo rule17697content1 = 
{
    (u_int8_t *) "-----BEGIN PGP MESSAGE-----", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_NOCASE|CONTENT_FAST_PATTERN|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule17697option1 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule17697content1
    }
};
// content:"Version|3A|", offset 2, depth 8, nocase, relative; 
static ContentInfo rule17697content2 = 
{
    (u_int8_t *) "Version|3A|", /* pattern (now in snort content format) */
    8, /* depth */
    2, /* offset */
    CONTENT_NOCASE|CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule17697option2 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule17697content2
    }
};
// content:"|0D 0A 0D 0A|", depth 0, relative; 
static ContentInfo rule17697content3 = 
{
    (u_int8_t *) "|0D 0A 0D 0A|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule17697option3 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule17697content3
    }
};

/* references for sid 17697 */
/* reference: cve "2006-3746"; */
static RuleReference rule17697ref1 = 
{
    "cve", /* type */
    "2006-3746" /* value */
};

/* reference: url "secunia.com/advisories/21297/"; */
static RuleReference rule17697ref2 = 
{
    "url", /* type */
    "secunia.com/advisories/21297/" /* value */
};

static RuleReference *rule17697refs[] =
{
    &rule17697ref1,
    &rule17697ref2,
    NULL
};
/* metadata for sid 17697 */
/* metadata:service smtp, policy security-ips drop; */
static RuleMetaData rule17697service1 = 
{
    "service smtp"
};


static RuleMetaData rule17697policy1 = 
{
    "policy security-ips drop"
};


static RuleMetaData *rule17697metadata[] =
{
    &rule17697service1,
    &rule17697policy1,
    NULL
};

RuleOption *rule17697options[] =
{
    &rule17697option0,
    &rule17697option1,
    &rule17697option2,
    &rule17697option3,
    NULL
};

Rule rule17697 = {
   /* rule header, akin to => tcp any any -> any any */
   {
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "25", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid */
       17697, /* sigid */
       3, /* revision */
       "attempted-user", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "SMTP GnuPG Message Packet Length overflow attempt",     /* message */
       rule17697refs /* ptr to references */
       ,rule17697metadata
   },
   rule17697options, /* ptr to rule options */
   &rule17697eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int rule17697eval(void *p) {
    const u_int8_t *cursor_normal = 0;
    const u_int8_t *beg_of_buffer, *end_of_buffer;

    u_int8_t decodedbuf[MAX_BASE64_BUFFER_SIZE], *decodedbuf_ptr;
    u_int32_t inputchars, decodedbytes;
    SFSnortPacket *sp = (SFSnortPacket *) p;

    uint32_t tmpval = 0;

    if(sp == NULL)
        return RULE_NOMATCH;

    if(sp->payload == NULL)
        return RULE_NOMATCH;
    
    // flow:established, to_server;
    if (checkFlow(p, rule17697options[0]->option_u.flowFlags) > 0 ) {
        // content:"-----BEGIN PGP MESSAGE-----", depth 0, nocase, fast_pattern;
        if (contentMatch(p, rule17697options[1]->option_u.content, &cursor_normal) > 0) {
            DEBUG_SO(printf("Matched the PGP header\n"));

            // content:"Version|3A|", offset 2, depth 8, nocase, relative;
            if (contentMatch(p, rule17697options[2]->option_u.content, &cursor_normal) > 0) {
                DEBUG_SO(printf("Matched the version\n"));

                // content:"|0D 0A 0D 0A|", depth 0, relative;
                if (contentMatch(p, rule17697options[3]->option_u.content, &cursor_normal) > 0) {
                    DEBUG_SO(printf("Matched the newline\n"));

                    if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_buffer, &end_of_buffer) != CURSOR_IN_BOUNDS)
                        return RULE_NOMATCH;
               
                    // We should now be at the beginning of the PGP data
                    // Four base64 input chars become three output chars
                    inputchars = (end_of_buffer > cursor_normal + (sizeof(decodedbuf) * 4 / 3)) ? (sizeof(decodedbuf) * 4 / 3) : end_of_buffer - cursor_normal;
                    DEBUG_SO(printf("Decoding %d bytes\n", inputchars));

                    // Only need 6 output bytes, plus 1 byte for the NULL added by base64decode()
                    if(base64decode(cursor_normal, inputchars, decodedbuf, 7, &decodedbytes) < 0) {
                        DEBUG_SO(printf("Failed to decode any data to work with\n"));
                        return RULE_NOMATCH;
                    }
                    
                    DEBUG_SO(printf("Decoded %d bytes\n", decodedbytes));

                    // Make sure we have enough data to work with
                    if(decodedbytes >= 6) {
                        decodedbuf_ptr = decodedbuf;

                        // New format with content tag of 16 or 61 (both in the first byte)
                        DEBUG_SO(printf("Packet format: %01x\n", decodedbuf[0]));

                        // The top two bits are set, the lower six we want to be either 16 or 61.
                        // 0xC0 + 16 = 0xD0,  0xC0 + 61 = 0xFD
                        if((decodedbuf[0] == (uint8_t)0xD0) || (decodedbuf[0] == (uint8_t)0xFD)) {

                            if(decodedbuf[1] == 0xFF) {
                               decodedbuf_ptr = decodedbuf + 2;

                               tmpval =  *decodedbuf_ptr++;
                               tmpval |= *decodedbuf_ptr++ << 8;
                               tmpval |= *decodedbuf_ptr++ << 16;
                               tmpval |= *decodedbuf_ptr++ << 24;

                               DEBUG_SO(printf("Packet Size: 0x%08x\n", tmpval));

                               if((tmpval >= 0xF9FFFFFF) && (tmpval <= 0xFEFFFFFF)) {
                                  return RULE_MATCH;
                               }
                            }
                        }       
                    }
                }
            }
        }
    }
    return RULE_NOMATCH;
}
/*
Rule *rules[] = {
    &rule17697,
    NULL
};
*/
