// Design: leds
// Description: leds on/ff
// Author: Isabel Gomez <igomez@us.es>
// Copyright Universidad de Sevilla, Spain
// Date: 14-12-2011

////////////////////////////////////////////////////////////////////////////////                                                                         //
// This file is free software: you can redistribute it and/or modify it under //
// the terms of the GNU General Public License as published by the Free       //
// Software Foundation, either version 3 of the License, or (at your option)  //
// any later version. You can access a copy of the GNU General Public License //
// at <http://www.gnu.org/licenses/>.                                         //
////////////////////////////////////////////////////////////////////////////////

/*
   This file describes a siple digital finite state machine. The system has 1 input (b)
   and eight outputs (z[7:0]). The outputs are conected to the LEDs in the board and when the input
   is "pressed" (1) light them in a progresive way.

   The system has an asynchronous reset that sets the system to an initial
   known state.
*/

`timescale 1ns / 1ps


module led(
 	input wire clk,		// clock
 	input wire reset,	// reset
	input wire x,	// input buttons
 	output reg  z		// output
 	);

 	// State encoding
 	parameter [1:0]
 		S0 = 2'b00,
 		S1 = 2'b01,
 		S2= 2'b10,
 		S3 = 2'b11;
 			// State and next state variables
	reg [3:0] state, next_state;

	// State change process (sequential part)
	always @(posedge clk, posedge reset)
		if (reset)
			state <= S0;
		else
			state <= next_state;

	// Next state calculation process (combinational)
	always @* begin
		next_state = 2'bxx;
		z='bx;
		case (state)
		S0:begin
			z=1;
			if (x == 1)
				next_state = S1;
			else
				next_state = S0;
		    end
		S1:begin
			z=0;
			if (x == 1)
				next_state = S2;
			else
				next_state = S1;
			end
		S2:begin
			z=1;
			if (x == 1)
				next_state = S3;
			else
				next_state = S2;
			end
		S3:begin
			z=1;
			if (x == 1)
				next_state = S0;
			else
				next_state = S3;
			end

		endcase
	end



endmodule // code
