// Design: calculator
// Description: Simple calculator for Digilent's Basys 2 board
// Copyright Universidad de Sevilla, Spain
// Date: 13-11-2011

////////////////////////////////////////////////////////////////////////////////                                                                         //
// This file is free software: you can redistribute it and/or modify it under //
// the terms of the GNU General Public License as published by the Free       //
// Software Foundation, either version 3 of the License, or (at your option)  //
// any later version. You can access a copy of the GNU General Public License //
// at <http://www.gnu.org/licenses/>.                                         //
////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
// Calculator                                                           //
//////////////////////////////////////////////////////////////////////////

/*
   This design describes a simple unsigned arithmetic unit with four simple 
   operations based on the 4-bit operation selection input signal 'op':
   
    op  | result
   -----+-------
   00 | a + b
   01 | a - b
   10 | a
   11 | b
   
   Operands 'a', 'b' and resulto are 4 bits (one hexadecimal digit*/

module arithmetic_unit (
	input wire [1:0] op,		// decoded operation selector
	input wire [3:0] a,		// first operand
	input wire [3:0] b,		// second operand
	output reg [3:0] z		// result
	);

	always @*
		casex (op)
			2'b00: z = a + b;
			2'b01: z = ;
			2'b10: z = ;
			2'b11: z = ;//completa las operaciones que faltan
		endcase

endmodule // arithmetic_unit
