// Design: calculator
// Description: Simple calculator for Digilent's Basys 2 board
// Author: Jorge Juan <jjchico@dte.us.es>
// Copyright Universidad de Sevilla, Spain
// Date: 13-11-2011

////////////////////////////////////////////////////////////////////////////////                                                                         //
// This file is free software: you can redistribute it and/or modify it under //
// the terms of the GNU General Public License as published by the Free       //
// Software Foundation, either version 3 of the License, or (at your option)  //
// any later version. You can access a copy of the GNU General Public License //
// at <http://www.gnu.org/licenses/>.                                         //
////////////////////////////////////////////////////////////////////////////////

`timescale 1ns / 1ps

//////////////////////////////////////////////////////////////////////////
// Calculator test bench                                                //
//////////////////////////////////////////////////////////////////////////

// This test bench applies a configurable number of random input patterns to
// the circuit under test.
// Simulation macros and default values:
//   NP: number of test patterns
//   SEED: initial seed for pseudo-random number generation

`ifndef NP
	`define NP 20
`endif
`ifndef SEED
	`define SEED 1
`endif

module test ();

	reg ck;			// system clock
	reg [3:0] a;		// first operand
	reg [3:0] b;		// second operand
	reg [1:0] op;		// decoded operation selector
	wire [0:6] seg;		// 7-segment output
	wire [3:0] an;		// anode output
	wire dp;		// decimal point output
	
	// Inititalization of pattern generation variables
	integer np = `NP;
	integer seed = `SEED;

	// Circuit under test
	// Calculator with cdbits reduced to easy simulation of the 
	// display controller
	calculator  uut (.a(a), .b(b), .op(op),
				      .seg(seg), .an(an), .dp(dp));

	initial begin
		
	
		op = 2'b00;
		
		// Waveform generation
		$dumpfile("test.vcd");
		$dumpvars(0, test);
		#200
		$finish; 
		end

	always begin
		#20
		a = $random(seed);
		b = $random(seed);
		#10 op=op+1;
		end
	
endmodule
