// Design: calculator
// Description: Simple calculator for Digilent's Basys 2 board
// Copyright Universidad de Sevilla, Spain
// Date: 13-11-2011

////////////////////////////////////////////////////////////////////////////////                                                                         //
// This file is free software: you can redistribute it and/or modify it under //
// the terms of the GNU General Public License as published by the Free       //
// Software Foundation, either version 3 of the License, or (at your option)  //
// any later version. You can access a copy of the GNU General Public License //
// at <http://www.gnu.org/licenses/>.                                         //
////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
// Calculator                                                           //
//////////////////////////////////////////////////////////////////////////

/*
   This design describes a simple hexadecimal calculator. The calculator does
   four simple operations based on the 4-bit operation selection input signal
   'op':

    op  | result
   -----+-------
   00 | a + b
   01 | a - b
   10 | a
   11 | b

   Operands 'a', 'b' and result are 4 bits (one hexadecimal digit). Result is 8 bits

   Output is generated by a 7-segment display controller intended to drive a
   4 digit hexadecimal 7-segment display as the one found in Digilent's FPGA
   boards.
 */

module calculator (
	input wire [3:0] a,		// first operand
	input wire [3:0] b,		// second operand
	input wire [1:0] op,		// decoded operation selector
	output wire [0:6] seg,		// 7-segment output
	output wire [3:0] an,		// anode output
	output wire dp			// decimal point output (disp. cont.)
	output wire [7:0] led //para visualización de los datos de entrada
	);

	// Internal signals
	wire [3:0] z;		// calculation result

	// Arithmetic unit
	//Aqui debes instanciar la unidad aritmética;
	sevenseg sevensega (.d(z),.seg(seg));

	// Decimal points are all off
	assign an = 4'b1110;
	assign dp = 1'b1;
	assign led={a,b};

	endmodule // calculator
