// Diseño: sevenseg
// Descripción: Codificador 7 segmentos
// 2019-02-13 Jorge Juan-Chico <jjchico@dte.us.es>

////////////////////////////////////////////////////////////////////////////////                                                                         //
// This file is free software: you can redistribute it and/or modify it under //
// the terms of the GNU General Public License as published by the Free       //
// Software Foundation, either version 3 of the License, or (at your option)  //
// any later version. You can access a copy of the GNU General Public License //
// at <http://www.gnu.org/licenses/>.                                         //
////////////////////////////////////////////////////////////////////////////////

/*
       0             Segmentos activos en nivel bajo
      ---
   5 |   | 1
      --- 6
   4 |   | 2
      ---
       3
*/

`timescale 1ns / 1ps

module sevenseg(
	input wire [3:0] d,		// Número de entrada
	output reg [0:6] seg	// Código 7 segmentos de salida
	);

	always @*
		case (d)
			4'h0: seg = 7'b0000001;
			4'h1: seg = 7'b1001111;
			4'h2: seg = 7'b0010010;
			4'h3: seg = 7'b0000110;
			4'h4: seg = 7'b1001100;
			4'h5: seg = 7'b0100100;
			4'h6: seg = 7'b0100000;
			4'h7: seg = 7'b0001111;
			4'h8: seg = 7'b0000000;
			4'h9: seg = 7'b0000100;
			4'ha: seg = 7'b0001000;
			4'hb: seg = 7'b1100000;
			4'hc: seg = 7'b0110001;
			4'hd: seg = 7'b1000010;
			4'he: seg = 7'b0110000;
			default: seg = 7'b0111000;
		endcase
endmodule	// sevenseg

/*
   Puede comprobar la sintáxis de este módulo con Icarus Verilog ejecutando
   en un terminal:

   $ iverilog sevenseg.v
 */
