// Design: code
// Description: Digital code key
// Author: Jorge Juan <jjchico@dte.us.es>
// Copyright Universidad de Sevilla, Spain
// Date: 14-12-2011

////////////////////////////////////////////////////////////////////////////////                                                                         //
// This file is free software: you can redistribute it and/or modify it under //
// the terms of the GNU General Public License as published by the Free       //
// Software Foundation, either version 3 of the License, or (at your option)  //
// any later version. You can access a copy of the GNU General Public License //
// at <http://www.gnu.org/licenses/>.                                         //
////////////////////////////////////////////////////////////////////////////////

`timescale 1ns / 1ps

// Test bench

module test();

	reg clk = 1;		// clock
	reg reset = 0;		// reset
	reg enable;		// input
	wire [7:0] z;			// output

	// Module instantiation
	generator uut(.clk(clk), .reset(reset), .enable(enable), .z(z));

	initial begin
		// Waveform generation
		$dumpfile("test.vcd");
		$dumpvars(0, test);

		// Initialization
		#5	reset = 1;
			enable = 0;
		#10	reset = 0;
		#15	;

		// Input data
		enable=1;
		#700	$finish;
	end

	always @(negedge clk)
		enable=~enable;
	// Clock generator
	always
		#10	clk = ~clk;
endmodule // test
