////////////////////////////////////////////////////////////////////////////////                                                                         //
// This file is free software: you can redistribute it and/or modify it under //
// the terms of the GNU General Public License as published by the Free       //
// Software Foundation, either version 3 of the License, or (at your option)  //
// any later version. You can access a copy of the GNU General Public License //
// at <http://www.gnu.org/licenses/>.                                         //
////////////////////////////////////////////////////////////////////////////////

module prescaler(
 	input wire clk,		// clock
  input wire reset,
 	output wire eoc		// output
 	);

	// State and next state variables
	reg [25:0] count;

  assign eoc = count>= 50000000-1;
	// State change process (sequential part)
	always @(posedge clk)
		if (reset | eoc)
			count <= 0;
		else
			count <= count+1;

endmodule
