// Design: leds
// Description: leds on/ff
// Author: Isabel Gomez <igomez@us.es>
// Copyright Universidad de Sevilla, Spain
// Date: 14-12-2011

////////////////////////////////////////////////////////////////////////////////                                                                         //
// This file is free software: you can redistribute it and/or modify it under //
// the terms of the GNU General Public License as published by the Free       //
// Software Foundation, either version 3 of the License, or (at your option)  //
// any later version. You can access a copy of the GNU General Public License //
// at <http://www.gnu.org/licenses/>.                                         //
////////////////////////////////////////////////////////////////////////////////

/*
   This file describes a siple digital finite state machine.
   The system has outputs (z[7:0]) that will be connected to LEDs.

   The system has an enable signal that will be connected to a button
   as well as an asynchronous reset that will be connected to a switch.
*/

`timescale 1ns / 1ps


module generator(
 	input wire clk,		// clock
 	input wire reset,	// reset
	input wire enable,	// input button
 	output reg [7:0] z		// output
 	);

	// State and next state variables
	reg [3:0] q, Q;

	// State change process (sequential part)
	always @(posedge clk, posedge reset)
		if (reset)
			q <= 0;
		else if(enable)
			q <= Q;

	// Next state calculation process (combinational)
	always @*
    Q=q+1;

  //output calculation (combinational)
	always @*
    case(q)
        4'h0:    z=8'b00000001;
        4'h1:    z=8'b00000010;
        4'h2:    z=8'b00000100;
        4'h3:    z=8'b00001000;
        4'h4:    z=8'b00010000;
        4'h5:    z=8'b00100000;
        4'h6:    z=8'b01000000;
        4'h7:    z=8'b10000000;
        4'h8:    z=8'b10000000;
        4'h9:    z=8'b01000000;
        4'ha:    z=8'b00100000;
        4'hb:    z=8'b00010000;
        4'hc:    z=8'b00001000;
        4'hd:    z=8'b00000100;
        4'he:    z=8'b00000010;
        default: z=8'b00000001;
    endcase

endmodule
