/*
	Autor: Alberto J. Molina
	ltima modificacin: 1-6-11
*//*
	En los pines del puerto B del microcontrolador se han colocado leds hasta
 	un total de ocho (uno por cada pin del puerto), de modo que un 1 lgico en
  	el pin, enciende el LED y un 0 lgico, lo apaga. En el pin PD2 se ha
   	conectado un pulsador mecanico de modo que si ste est presionado, 
   	introduce un 0 lgico en el pin, y un 1 cuando est en reposo.  
   	Al inicio, todos los leds estarn apagados y el microcontrolador
   	esperando que la tecla se pulse. Cuando el microcontrolador contabilice
	dos pulsaciones, todos los leds se pondrn en intermitencia con 
	periodo de 1 segundo (0.5 segundos encendidos y 0.5 segundos apagados).
	Disee el programa usando interrupciones para el temporizador. 
	Supngase que la frecuencia de reloj es de 4Mhz (periodo de 250ns).
	  
	   
*/
	.include "m328pdef.inc"


	
	.def	temporal = r16
	.def	ContPulsos = r17


	.cseg

		.org	0
		jmp		Reset
		.org	$16	
		jmp		IntTimer1
		


Reset:
		rcall   ConfiguraES
		clr		ContPulsos

/*************************************************************
	Programa

		hacer
			mientras (Pd[2] == 1)
			fin mientras

			ContPulsos <- ContPulsos +1
			
			mientras (Pd[2] == 0)
			fin mientras

		mientras( ContPulsos <2)
		fin

*************************************************************/



Programa:						;hacer
		sbic	pind,2			;	mientras (Pd[2] == 1)
		rjmp	Programa		;	fin mientras
		inc		ContPulsos		; 	ContPulsos <- ContPulsos +1

LiberaTecla:
		sbis	pind,2			;	mientras (Pd[2] == 0)
		rjmp	LiberaTecla		;	fin mientras

		cpi		ContPulsos,2
		breq	Fin				
		rjmp	Programa		;mientras( ContPulsos <2)

Fin:	rjmp	Fin				;fin



/*****************************************************************
RUTINA DE CONFIGURACIN DE LA ES
	- TIMER1
	
	
		
	
		Registros usados:
		-OCCR1AH, OCCR1AL
		-TCCRIB
			-----------------------------------------------------
			| 0  |  0  |  0  |  0  | WGM12 | CS12 | CS11 | CS10 |
			-----------------------------------------------------
				WGM12 =>  1: Modo CTC ; 0: Modo Normal
				CS12:0 => Seleccin del Prescaler
						   --------------------------------
						   | 0  0  0  |  Parada	          |
						   | 0  0  1  |  clk	          |
						   | 0  1  0  |  clk/8            |
						   | 0  1  1  |  clk/64           |
						   | 1  0  0  |  clk/256          |
						   | 1  0  1  |  clk/1024         |
						   | 1  1  0  |  T1 flanco bajada |
						   | 1  1  1  |  T1 flanco subida |
						   --------------------------------
		- TCNT1H,TCNT1L
		- TIMSK1
			----------------------------------------------------------
			| -  |  -  |  0  |  -  |  -  |  -  |  0  | OCIE1 | TOIE1 |
			----------------------------------------------------------	
				OCIE1: Output compare interrupt enable
						0: Disable
						1: Enable
				TOIE1: Timer overflow interrupt enable
						0: Disable
						1: Enable


	Con una frecuencia de 4Mhz, se trata de generar interrupciones cada
	0.5 segundos. Para ello tendremos que ver cules son las posibles
	combinaciones y escoger aqulla que genere menor error
		
			   cs2:0	OCR1A		COMENTARIO
 			 ------------------------------------------
			 | 0  0  1  | 2000000  	|   No es posible |
			 | 0  1  0  |  250000   |   No es posible | 
			 | 0  1  1  | 	31250 	|   Posible y exacto
			 | 1  0  0  |  	 7812,5 |   Posible aunque inexacto OCR1A=7812 
			 | 1  0  1  |   1953,125|   Poseible aunque inexacto OCR1A =976
			 ------------------------------------------
	;La mejor solucin es escoger un prescaler de 64 y OCREA igual a 31250 =$7a12

	;Con una frecuencia de 4Mhz, Prescaler 64, modo CTC y 
		;Ocr1a = 31250 obtenemos que el timer se pone a 0 cada 
		; 31250 x 250 ns x 64 = 0.5s  



	PSEUDOCDIGO:
	sub ConfiguraES
		DDRD <- $FF		;Puerto D como salida
		PORTD <- 0      ;Apagamos diodos
		DDRB[2] <- 0    ;Pin 2 del puerto B como entrada

		OCR1A <- 31250	;Lmite de comparacin en 31250   (Escribir 1 en la parte H y despus en L) 
		TCCR1B <- 11 	;Prescaler 64 y modo CTC
		TCNT1 <- 0		;Contador a 0 (Escribir 1 en la parte H y despus en L)
		TIMSK1 <- 2		;Habilitacin de la interrupcin por comparacin
		I <- 1			;Habilitar interrupcin global
		
	fin ConfiguraES
******************************************************************/

ConfiguraES:					;	sub ConfiguraES

		ldi		temporal,$ff
		out		ddrb,temporal	;		DDRD <- $FF	Puerto D como salida

		clr		temporal		;		PORTD <- 0      ;Apagamos diodos
		out		portb,temporal	;		

		cbi		ddrd,2			;		DDRB[2] <- 0    ;Pin 2 del puerto B como entrada


		ldi		temporal, $7a	;		OCR1A <- 31250	;Lmite de comparacin en 5000   (Escribir 1 en la parte H y despus en L) 
		sts		ocr1ah,temporal
		ldi		temporal, $12
		sts		ocr1al,temporal	;ocr1a = $7a12

		ldi		temporal, 0b00001011 
		;ldi		temporal, 0b00001001       ; Para depuracin Prescaler a 1 y modo CTC
		sts		tccr1b,temporal	;		TCCR1B <- 11 	;Prescaler 64 y modo CTC 	


		ldi		temporal,0			;	TCNT1 <- 0		;Contador a 0 (Escribir 1 en la parte H y despus en L)

		sts		tcnt1h,temporal
		sts		tcnt1l,temporal		

		ldi		temporal,2			;	TIMSK1 <- 2		;Habilitacin de la interrupcin por comparacin
		sts		timsk1,temporal	


		sei							;	I <- 1			;Habilitar interrupcin global





		ret							;fin ConfiguraES



;********************************************************
/*	subr IntTimer1
		STACK <- SREG
		si (ContPulsos>= 2)
			PORTB <- ~PINB
		fsi
		SREG <- STACK
;	end IntTimer1*/
;********************************************************
IntTimer1:	
		in		temporal,sreg
		push	temporal
		
		cpi		ContPulsos,2
		brlo	FinInt
		
		in		temporal,pinb
		com		temporal
		out		portb,temporal


FinInt: pop		temporal
		out		sreg,temporal		
		reti
