/*
	Autor: Alberto J. Molina
	ltima modificacin: 1-6-13
*/
/*
   El sistema digital de la figura est construido con un microcontrolador
   ATMega648p, dos registros de 8 bits (74573) y 2 visualizadores de siete
   segmentos. Se desea obtener un conjunto de subrutinas que permitan la
   representacin de cualquier nmero entre 0 y 99 en los displays de 7 
   segmentos. Adems se pide definir las interconexiones entre el 
   microcontrolador y los latches y entre estos ltimos y los displays 
   de siete segmentos.

*/


/*

	Como se observa en la figura del enunciado, se utilizar un puerto,
	por ejemplo el PORTB, como bus que interconecta ambos latches con el
	microcontrolador. La conexin se lleva a cabo utilizando los pines D 
	de cada latch. Adems, para que estos registros capturen los datos que 
	el microcontrolador sita en el bus, o puerto B, se debern activar 
	sendas seales, LE, manejadas por dos pines del puerto D del 
	microcontrolador. Los terminales OE de cada registro debern ponerse
	a tierra, para que estos estn continuamente activando los leds de los 
	displays de 7 segmentos, que son del tipo ctodo comn. 
	La siguiente tabla resume una posible solucin de interconexin. 

Microcontrolador |   		Latches		 |	Display de 7 segmentos
				 |	Input   |   Output   |
---------------------------------------------------------------------
PB0              |    1D    |     1Q     |   Segmento a
PB1              |    2D    |     2Q     |   Segmento b
						........
PB6              |    7D    |     7Q     |   Segmento g
PB7              |    8D    |     8Q     |   Segmento h
PD0              |    LE1   |   ------   |   ----------
PD1              |    LE2   |   ------   |   ----------


	La tabla con los cdigos 7 segmentos se har residente en la memoria de 
	programa. Se acceder a un elemento de la tabla, utilizando la instruccin 
	LPM. Se recuerda que esta instruccin requiere que el registro Z apunte a 
	la zona de la memoria de programa donde se encuentra la tabla y, segn si
 	el contenido de Z es par o impar, se acceder al byte bajo o alto,
 	respectivamente. Dicho byte se deposita en el registro R0.


	Supondremos que la rutina a disear recibe el nmero que tiene que 
	representar en los displays en el formato BCD:

				-----------------
		Nmero  |0 .. 9 | 0 .. 9|
				-----------------
 
La rutina recibe el nmero N en un registro. Cada dgito del mismo, 
se utilizar para obtener, junto con el registro Z, el cdigo 7 segmentos 
correspondiente, el cual se sita en el puerto B y se genera el pulso en 
el pin PD para proceder a su carga. Se repite el procedimiento con el otro 
dgito.



*/


	.include "m328pdef.inc"

	.equ	CERO = 0b00111111
	.equ	UNO  = 0b00000110
	.equ	DOS  = 0b01011011
	.equ	TRES = 0b01001111
	.equ	CUATRO=0b01100110
	.equ	CINCO= 0b01101101
	.equ	SEIS=  0b01111100
	.equ	SIETE= 0b00000111
	.equ	OCHO=  0b01111111
	.equ	NUEVE= 0b01100111
	
	.equ	LE1 = 0
	.EQU	LE2 = 1


	.def	temp = r16
	.def	N = r17
	.def	cer= r18

	.cseg



Reset:	rcall  Inicializacion		;Para depuracin
		rcall  ConfiguraES
Programa:
		rcall	Representa

Fin:	rjmp	Fin	


;*****************************************************************
;					Pseudocdigo de la rutina Representa
;
;	Subr Representa
;		Z <- 2*Tabla7Seg (Ver transparencias de Tablas de datos en memoria de cdigo )
;		Temp <- DigitoLsb(N)     (1)
;		Z <- Z + Temp			 (3)
;  		R0 <- MEMCOD ( Z)
;		PORTB <- R0
;		PORTD[LE1] <- 1
;		PORTD[LE1] <- 0
;
;		Z <- 2*Tabla7Seg (Ver transparencias de Tablas de datos en memoria de cdigo )
;		Temp <- DigitoMSB(N)     (2)
;		Z <- Z + Temp
;  		R0 <- MEMCOD ( Z)
;		PORTB <- R0
;		PORTD[LE2] <- 1
;		PORTD[LE2] <- 0
;
;	End  Representa
;
; (1) Para implementar Temp<-DigitloLsb(N), bastara con:
; 		Temp <- N
;		Temp <-  Temp & 0x0F
;		Ejemplo:  N=0110 1000
;				Temp<- N  hace que Temp = 0110 1000
;				Temp<- Temp & 0x0f hace una AND =>  Temp = 0000 1000
;				Por tanto Temp tiene el DigitoLSB (N)
; (2) Para implementar R0<-DigitloMSB(N), bastara con:
; 		Temp <- N
;		Temp[7:4] <->   Temp[3:0]
;		Ejemplo:  N=0110 1000
;				Temp<- N  hace que Temp = 1000 0110 
;				Temp<- Temp & 0x0f hace que  Temp = 0000 0110
;				Por tanto Temp tiene el DigitoMSB (N)
;
; (3) Para implementar Z <- Z + temp se debe tener en cuenta que Z
;	  es de tamao W (16 bits) y Temp de tamao (B)
;
;			-------------
;           | ZH  |  ZL |
;           -------------
;           |  0  | Temp| +
;        -------------------
;           
;*****************************************************************

Representa:

		ldi		zl,low(2*Tabla7Seg)		;	Subr Representa
		ldi		zh,high(2*Tabla7Seg)	;		Z<- Tabla7Seg
		
		mov		temp,N					; 		temp <- N
		andi	temp,$F					;		temp <- temp & 0x0F
		clr		cer
		add		zl,temp
		adc		zh,cer					;		Z <- Z+Temp
		lpm								;  		R0 <- MEMCOD ( Z)
		out		portb,r0				;		PORTB <- R0
		sbi		portd, LE1				;		PORTD[LE1] <- 1 
		nop								;    
		cbi		portd,LE1 				;		PORTD[LE1] <- 0


		ldi		zl,low(2*Tabla7Seg)
		ldi		zh,high(2*Tabla7Seg)	;		Z<- Tabla7Seg
		mov		temp,N					; 		Temp <- N
		swap	temp					;		Intercambia nibbles
		andi	temp,$F					;		Temp <- Temp 0x0f
		clr		cer						;
		add		zl,temp
		adc		zh,cer					;		Z <- Z+Temp
		lpm								;  		R0 <- MEMCOD ( Z)
		out		portb,r0				;		PORTB <- R0
		sbi		portd, LE2				;		PORTD[LE2] <- 1 
		nop
		cbi		portd,LE2 				;		PORTD[LE1] <- 0 
		
		ret								;	End Representa

/******************************************************************
	RUTINA ConfiguraES
		Puerto B como salida
		Pines 1:0 del puerto D como salidas


	sub ConfiguraES
		DDRB <- $FF		;Puerto B como salida
		DDRD[1:0] <- 3  ; Pines 1y0 del puerto D como salidas
	fin ConfiguraES
******************************************************************/



ConfiguraES:					;sub ConfiguraES
		ldi		temp,0XFF
		out		DDRB,temp		; DDRD <- $FF
		LDI		temp,3
		OUT     DDRD,temp		; DDRD <- 3
		RET						;end ConfiguraES




//Para depuracin
Inicializacion:
		ldi		N, $23		;Mete en BCD el nmero 23
		ret				





Tabla7Seg: .db CERO,UNO,DOS,TRES,CUATRO,CINCO,SEIS,SIETE,OCHO,NUEVE




