/* Recuerde que en el AVR el registro Z es de 16 bits
   y tiene parte alta (ZH) y parte baja (ZL),
   que se ubican en R31 y R30 respectivamente.
   El registro Y es similar y su parte alta y baja,
   YH e YL se ubican en R29 y R28 respectivamente.
   Z es ZH:ZL y equivale a R31:R30
   Y es YH:YL y equivale a R29:R28
*/

; Inicializamos el puntero Z con la direccion 0x0100
;             y el puntero Y con la direccion 0x0130 

        ldi r31,0x01
        ldi r30,0x00
        ldi r29,0x01
        ldi r28,0x30

; Usando el puntero Z, inicializamos una tabla con 4 datos
; de 8 bits, desde la direccion 0x0100 hacia adelante.

        ldi r16,25
        st z+,r16
        ldi r16,26
        st z+,r16
        ldi r16,27
        st z+,r16
        ldi r16,28
        st z+,r16

; Usando el puntero Y, inicializamos una tabla con 4 datos
; de 8 bits, desde la direccion 0x0130 hacia adelante.

        ldi r16,117
        st y+,r16
        ldi r16,116
        st y+,r16
        ldi r16,115
        st y+,r16
        ldi r16,114
        st y+,r16

; Cargamos de nuevo el puntero Z con la direccion 0x0100
;                 y el puntero Y con la direccion 0x0130 

        ldi r31,0x01
        ldi r30,0x00
        ldi r29,0x01
        ldi r28,0x30

; Mediante un bucle controlado por el registro r16 y,
; usando los punteros Z e Y, se recorren las dos tablas
; anteriores y se van intercambiando de una tabla a
; otra los 4 datos de 8 bits contenidos en ellas.

        ldi r16,4
cambia: ld r0,z
        ld r1,y
        st z+,r1
        st y+,r0
        subi r16,1
        brne cambia

fin:    jmp fin      ; Bucle infinito, simula un STOP
